//
//  GeometryGamesMesh.swift
//  Crystal Flight
//
//  Created by Jeff on 15/10/20.
//  Copyright © 2020 Jeff Weeks. All rights reserved.
//

import Metal


class GeometryGamesMesh {

	let itsVertexCount: UInt
	let itsVertexStride: UInt
	let itsIndexCount: UInt
	let itsIndexType: MTLIndexType
	let itsVertexBuffer: MTLBuffer
	let itsIndexBuffer: MTLBuffer
	
	init(
		device: MTLDevice,
		numVertices: UInt,
		vertexStride: UInt,	//	vertex stride in bytes
		numIndices: UInt,
		indexType: MTLIndexType)
	{
		itsVertexCount = numVertices
		itsVertexStride = vertexStride
		itsIndexCount = numIndices
		itsIndexType = indexType
		
		guard let theVertexBuffer = device.makeBuffer(
			length: Int(numVertices * vertexStride),
			options: [MTLResourceOptions.storageModeShared]
		) else {
			fatalError("Couldn't make theVertexBuffer in GeometryGamesMesh()")
		}
		itsVertexBuffer = theVertexBuffer
		
		let theIndexStride: UInt	//	index stride in bytes
		switch indexType {
		case .uint16:
			theIndexStride = UInt(MemoryLayout<UInt16>.stride)	//	= 2
		case .uint32:
			theIndexStride = UInt(MemoryLayout<UInt32>.stride)	//	= 4
		@unknown default:
			fatalError("Unknown indexType in GeometryGamesMesh()")
		}
		
		guard let theIndexBuffer = device.makeBuffer(
			length: Int(numIndices * theIndexStride),
			options: [MTLResourceOptions.storageModeShared]
		) else {
			fatalError("Couldn't make theIndexBuffer in GeometryGamesMesh()")
		}
		itsIndexBuffer = theIndexBuffer
	}
}
